/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.database.client.sql.h2;

import java.sql.Connection;
import java.sql.SQLException;
import me.hsgamer.hscore.database.Driver;
import me.hsgamer.hscore.database.Setting;
import me.hsgamer.hscore.database.client.sql.BaseSqlClient;
import me.hsgamer.hscore.database.driver.h2.H2BaseDriver;
import org.h2.jdbcx.JdbcDataSource;

public class H2Client
extends BaseSqlClient<JdbcDataSource> {
    private final JdbcDataSource dataSource;

    public H2Client(Setting setting) {
        super(setting);
        Driver driver = setting.getDriver();
        if (!(driver instanceof H2BaseDriver)) {
            throw new IllegalArgumentException("The driver must be H2");
        }
        this.dataSource = new JdbcDataSource();
        this.dataSource.setURL(driver.convertURL(setting));
        this.dataSource.setUser(setting.getUsername());
        this.dataSource.setPassword(setting.getPassword());
    }

    public JdbcDataSource getOriginal() {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

