/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.downloader.core;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.hsgamer.hscore.downloader.core.loader.DownloadInfoLoader;
import me.hsgamer.hscore.downloader.core.loader.InputStreamLoader;
import me.hsgamer.hscore.downloader.core.object.DownloadInfo;

public class Downloader {
    private static final Logger logger = Logger.getLogger(Downloader.class.getSimpleName());
    private final Map<String, DownloadInfo> downloadInfoMap = new ConcurrentHashMap<String, DownloadInfo>();
    private final AtomicBoolean isLoaded = new AtomicBoolean(false);
    private final DownloadInfoLoader downloadInfoLoader;
    private final InputStreamLoader inputStreamLoader;
    private final File folder;

    public Downloader(DownloadInfoLoader downloadInfoLoader, InputStreamLoader inputStreamLoader, File folder) {
        this.downloadInfoLoader = downloadInfoLoader;
        this.inputStreamLoader = inputStreamLoader;
        this.folder = folder;
        if (!folder.exists() && folder.mkdirs()) {
            logger.info(() -> "Create folder: " + folder.getAbsolutePath());
        }
    }

    public File getFolder() {
        return this.folder;
    }

    public DownloadInfoLoader getDownloadInfoLoader() {
        return this.downloadInfoLoader;
    }

    public InputStreamLoader getInputStreamLoader() {
        return this.inputStreamLoader;
    }

    public Optional<DownloadInfo> getDownloadInfo(String name) {
        return Optional.ofNullable(this.downloadInfoMap.get(name));
    }

    public Map<String, DownloadInfo> getLoadedDownloadInfo() {
        return Collections.unmodifiableMap(this.downloadInfoMap);
    }

    public boolean isLoaded() {
        return this.isLoaded.get();
    }

    public void setup() {
        this.isLoaded.set(false);
        this.downloadInfoMap.clear();
        this.downloadInfoLoader.load(this).whenCompleteAsync((map, throwable) -> {
            if (throwable != null) {
                logger.log(Level.WARNING, "A throwable occurred when loading download info", (Throwable)throwable);
            }
            if (map != null) {
                this.downloadInfoMap.putAll((Map<String, DownloadInfo>)map);
            }
            this.isLoaded.set(true);
            this.onLoaded();
        });
    }

    public void onLoaded() {
    }
}

