/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.downloader.core.loader;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import me.hsgamer.hscore.downloader.core.Downloader;
import me.hsgamer.hscore.downloader.core.loader.DownloadInfoLoader;
import me.hsgamer.hscore.downloader.core.object.DownloadInfo;
import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;
import me.hsgamer.hscore.logger.provider.LoggerProvider;

public abstract class MapDownloadInfoLoader
implements DownloadInfoLoader {
    private static final Logger logger = LoggerProvider.getLogger(MapDownloadInfoLoader.class);

    private DownloadInfo getDownloadInfo(Downloader downloader, String name, Map<String, Object> map) {
        if (!map.containsKey("file-name")) {
            throw new IllegalArgumentException("The download info doesn't have a file name");
        }
        String fileName = String.valueOf(map.get("file-name"));
        if (!map.containsKey("version")) {
            throw new IllegalArgumentException("The download info doesn't have a version");
        }
        String version = String.valueOf(map.get("version"));
        if (!map.containsKey("direct-link")) {
            throw new IllegalArgumentException("The download info doesn't have a direct link");
        }
        String directLink = String.valueOf(map.get("direct-link"));
        return new DownloadInfo(name, fileName, version, directLink, map, downloader);
    }

    protected abstract CompletableFuture<Map<String, Map<String, Object>>> loadMap(Downloader var1);

    @Override
    public CompletableFuture<Map<String, DownloadInfo>> load(Downloader downloader) {
        return this.loadMap(downloader).thenApply(stringMapMap -> {
            if (stringMapMap == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap map = new LinkedHashMap();
            stringMapMap.forEach((name, value) -> {
                try {
                    DownloadInfo downloadInfo = this.getDownloadInfo(downloader, (String)name, (Map<String, Object>)value);
                    map.put(name, downloadInfo);
                }
                catch (Exception e) {
                    logger.log(LogLevel.WARN, "Something wrong when parsing the info of " + name, (Throwable)e);
                }
            });
            return map;
        });
    }
}

