/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.downloader.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import me.hsgamer.hscore.downloader.core.Downloader;
import me.hsgamer.hscore.downloader.core.loader.MapDownloadInfoLoader;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonDownloadInfoLoader
extends MapDownloadInfoLoader {
    private final String dbUrl;
    private final UserAgent userAgent;

    public JsonDownloadInfoLoader(String dbUrl, UserAgent userAgent) {
        this.dbUrl = dbUrl;
        this.userAgent = userAgent;
    }

    public JsonDownloadInfoLoader(String dbUrl) {
        this(dbUrl, UserAgent.FIREFOX);
    }

    protected CompletableFuture<Map<String, Map<String, Object>>> loadMap(Downloader downloader) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return new InputStreamReader(this.userAgent.assignToConnection(WebUtils.createConnection((String)this.dbUrl)).getInputStream());
            }
            catch (IOException e) {
                throw new CompletionException("Something wrong when getting the info", e);
            }
        }).thenApplyAsync(inputStreamReader -> {
            try {
                return new JSONParser().parse((Reader)inputStreamReader);
            }
            catch (IOException | ParseException e) {
                throw new CompletionException("Something wrong when parsing the info", e);
            }
        })).thenApplyAsync(jsonObject -> {
            if (!(jsonObject instanceof JSONObject)) {
                return Collections.emptyMap();
            }
            HashMap map = new HashMap();
            ((JSONObject)jsonObject).forEach((key, raw) -> {
                if (!(raw instanceof JSONObject)) {
                    return;
                }
                String name = String.valueOf(key);
                HashMap valueMap = new HashMap();
                ((JSONObject)raw).forEach((key1, raw1) -> valueMap.put(String.valueOf(key1), raw1));
                map.put(name, valueMap);
            });
            return map;
        });
    }
}

