/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.downloader.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import me.hsgamer.hscore.downloader.core.Downloader;
import me.hsgamer.hscore.downloader.core.loader.MapDownloadInfoLoader;
import me.hsgamer.hscore.web.UserAgent;
import me.hsgamer.hscore.web.WebUtils;

public class JsonDownloadInfoLoader
extends MapDownloadInfoLoader {
    private final String dbUrl;
    private final UserAgent userAgent;

    public JsonDownloadInfoLoader(String dbUrl, UserAgent userAgent) {
        this.dbUrl = dbUrl;
        this.userAgent = userAgent;
    }

    public JsonDownloadInfoLoader(String dbUrl) {
        this(dbUrl, UserAgent.FIREFOX);
    }

    protected CompletableFuture<Map<String, Map<String, Object>>> loadMap(Downloader downloader) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return new InputStreamReader(WebUtils.createConnection((String)this.dbUrl, arg_0 -> ((UserAgent)this.userAgent).assignToConnection(arg_0)).getInputStream());
            }
            catch (IOException e) {
                throw new CompletionException("Something wrong when getting the info", e);
            }
        }).thenApplyAsync(inputStreamReader -> {
            try {
                return JsonParser.parseReader((Reader)inputStreamReader);
            }
            catch (Exception e) {
                throw new CompletionException("Something wrong when parsing the info", e);
            }
        })).thenApplyAsync(element -> {
            if (!element.isJsonObject()) {
                return Collections.emptyMap();
            }
            JsonObject jsonObject = element.getAsJsonObject();
            HashMap map = new HashMap();
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
                HashMap<String, String> infoMap = new HashMap<String, String>();
                for (Map.Entry infoEntry : object.entrySet()) {
                    infoMap.put((String)infoEntry.getKey(), ((JsonElement)infoEntry.getValue()).getAsString());
                }
                map.put((String)entry.getKey(), infoMap);
            }
            return map;
        });
    }
}

