/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.expansion.common.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import me.hsgamer.hscore.expansion.common.factory.MapExpansionDescriptionLoader;

public abstract class InputStreamExpansionDescriptionLoader
implements MapExpansionDescriptionLoader {
    private final String descriptionFileName;

    protected InputStreamExpansionDescriptionLoader(String descriptionFileName) {
        this.descriptionFileName = descriptionFileName;
    }

    public abstract Map<String, Object> applyAsMap(InputStream var1);

    @Override
    public Map<String, Object> applyAsMap(JarFile jarFile) {
        Map<String, Object> map;
        block9: {
            JarEntry jarEntry = jarFile.getJarEntry(this.descriptionFileName);
            if (jarEntry == null) {
                throw new IllegalStateException("The file " + jarFile.getName() + " does not contain the file " + this.descriptionFileName);
            }
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            try {
                map = this.applyAsMap(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("There is an I/O error when loading configuration of " + jarFile.getName(), e);
                }
            }
            inputStream.close();
        }
        return map;
    }
}

