/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.expansion.common;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Optional;
import me.hsgamer.hscore.expansion.common.Expansion;
import me.hsgamer.hscore.expansion.common.ExpansionDescription;
import me.hsgamer.hscore.expansion.common.ExpansionManager;
import me.hsgamer.hscore.expansion.common.ExpansionState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpansionClassLoader
extends URLClassLoader {
    @NotNull
    private final File file;
    @NotNull
    private final ExpansionManager manager;
    @NotNull
    private final ExpansionDescription description;
    @Nullable
    private Expansion expansion;
    @NotNull
    private ExpansionState currentState = ExpansionState.UNKNOWN;
    private Throwable throwable;

    public ExpansionClassLoader(@NotNull ExpansionManager manager, @NotNull File file, @NotNull ExpansionDescription description, @NotNull ClassLoader parent) throws MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        this.manager = manager;
        this.file = file;
        this.description = description;
    }

    public Optional<Expansion> getExpansionOptional() {
        return Optional.ofNullable(this.expansion);
    }

    @NotNull
    public Expansion getExpansion() {
        return this.getExpansionOptional().orElseThrow(() -> new IllegalStateException("Expansion not found or not initialized"));
    }

    @NotNull
    public File getFile() {
        return this.file;
    }

    @NotNull
    public ExpansionManager getManager() {
        return this.manager;
    }

    @NotNull
    public ExpansionDescription getDescription() {
        return this.description;
    }

    @NotNull
    public ExpansionState getState() {
        return this.currentState;
    }

    void setState(@NotNull ExpansionState state) {
        if (this.currentState == state) {
            return;
        }
        this.manager.notifyStateChange(this, state);
        this.currentState = state;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(@NotNull Throwable throwable) {
        this.throwable = throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.loadClass(name, resolve, true);
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
            return clazz;
        }
    }

    @Nullable
    Class<?> loadClass(@NotNull String name, boolean resolve, boolean global) {
        Class<?> clazz;
        block2: {
            clazz = null;
            try {
                clazz = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                if (!global) break block2;
                clazz = this.manager.loadClass(this, name, resolve);
            }
        }
        return clazz;
    }

    void initExpansion() {
        this.expansion = this.manager.getExpansionFactory().apply(this);
    }
}

