/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.expression.ezylang;

import com.ezylang.evalex.EvaluationException;
import com.ezylang.evalex.Expression;
import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.data.EvaluationValue;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.operators.OperatorIfc;
import com.ezylang.evalex.parser.ParseException;
import java.util.Map;
import me.hsgamer.hscore.expression.ezylang.number.Average;
import me.hsgamer.hscore.expression.ezylang.string.Contains;
import me.hsgamer.hscore.expression.ezylang.string.EndsWith;
import me.hsgamer.hscore.expression.ezylang.string.Equals;
import me.hsgamer.hscore.expression.ezylang.string.EqualsIgnoreCase;
import me.hsgamer.hscore.expression.ezylang.string.Length;
import me.hsgamer.hscore.expression.ezylang.string.MatchPattern;
import me.hsgamer.hscore.expression.ezylang.string.StartsWith;

public final class ExpressionUtils {
    private static ExpressionConfiguration expressionConfiguration = ExpressionConfiguration.defaultConfiguration().withAdditionalFunctions(new Map.Entry[]{Map.entry("AVG", new Average()), Map.entry("STRCT", new Contains()), Map.entry("STREDW", new EndsWith()), Map.entry("STREQ", new Equals()), Map.entry("STREQIC", new EqualsIgnoreCase()), Map.entry("STRLEN", new Length()), Map.entry("STRMP", new MatchPattern()), Map.entry("STRSTW", new StartsWith())});

    private ExpressionUtils() {
    }

    public static void registerFunction(String name, FunctionIfc function) {
        expressionConfiguration = expressionConfiguration.withAdditionalFunctions(new Map.Entry[]{Map.entry(name, function)});
    }

    public static void registerOperator(String name, OperatorIfc operator) {
        expressionConfiguration = expressionConfiguration.withAdditionalOperators(new Map.Entry[]{Map.entry(name, operator)});
    }

    public static ExpressionConfiguration getExpressionConfiguration() {
        return expressionConfiguration;
    }

    public static Expression createExpression(String expression) {
        return new Expression(expression, expressionConfiguration);
    }

    public static EvaluationValue evaluate(String expression) throws EvaluationException, ParseException {
        return ExpressionUtils.createExpression(expression).evaluate();
    }

    public static EvaluationValue evaluate(String expression, Map<String, Object> values) throws EvaluationException, ParseException {
        return ExpressionUtils.createExpression(expression).withValues(values).evaluate();
    }
}

