/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.expression;

import com.udojava.evalex.Expression;
import com.udojava.evalex.LazyFunction;
import com.udojava.evalex.LazyOperator;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.hsgamer.hscore.expression.number.Average;
import me.hsgamer.hscore.expression.string.Contains;
import me.hsgamer.hscore.expression.string.EndsWith;
import me.hsgamer.hscore.expression.string.Equals;
import me.hsgamer.hscore.expression.string.EqualsIgnoreCase;
import me.hsgamer.hscore.expression.string.Length;
import me.hsgamer.hscore.expression.string.MatchPattern;
import me.hsgamer.hscore.expression.string.StartsWith;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionUtils {
    private static final Set<LazyFunction> lazyFunctionSet = new HashSet<LazyFunction>();
    private static final Set<LazyOperator> lazyOperatorSet = new HashSet<LazyOperator>();

    private ExpressionUtils() {
    }

    public static boolean isBoolean(@NotNull String input) {
        Expression expression = new Expression(input);
        ExpressionUtils.applyLazyFunction(expression);
        ExpressionUtils.applyLazyOperator(expression);
        try {
            return expression.isBoolean();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Nullable
    public static BigDecimal getResult(@NotNull String input) {
        Optional<BigDecimal> number = ExpressionUtils.getNumber(input);
        if (number.isPresent()) {
            return number.get();
        }
        try {
            return ExpressionUtils.createExpression(input).eval();
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public static Expression createExpression(@NotNull String input) {
        Expression expression = new Expression(input);
        ExpressionUtils.applyLazyFunction(expression);
        ExpressionUtils.applyLazyOperator(expression);
        return expression;
    }

    public static boolean isValidExpression(@NotNull String input) {
        return ExpressionUtils.getResult(input) != null;
    }

    public static void applyLazyFunction(@NotNull Expression expression) {
        lazyFunctionSet.forEach(arg_0 -> ((Expression)expression).addLazyFunction(arg_0));
    }

    public static void registerLazyFunction(@NotNull LazyFunction lazyFunction) {
        lazyFunctionSet.add(lazyFunction);
    }

    public static void applyLazyOperator(@NotNull Expression expression) {
        lazyOperatorSet.forEach(arg_0 -> ((Expression)expression).addOperator(arg_0));
    }

    public static void registerLazyOperator(@NotNull LazyOperator lazyOperator) {
        lazyOperatorSet.add(lazyOperator);
    }

    @NotNull
    private static Optional<BigDecimal> getNumber(@NotNull String input) {
        try {
            return Optional.of(new BigDecimal(input));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    static {
        lazyFunctionSet.add((LazyFunction)new Equals());
        lazyFunctionSet.add((LazyFunction)new EqualsIgnoreCase());
        lazyFunctionSet.add((LazyFunction)new Contains());
        lazyFunctionSet.add((LazyFunction)new StartsWith());
        lazyFunctionSet.add((LazyFunction)new EndsWith());
        lazyFunctionSet.add((LazyFunction)new Length());
        lazyFunctionSet.add((LazyFunction)new MatchPattern());
        lazyFunctionSet.add((LazyFunction)new Average());
    }
}

