/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.expression;

import com.ezylang.evalex.config.ExpressionConfiguration;
import com.ezylang.evalex.functions.FunctionIfc;
import com.ezylang.evalex.operators.OperatorIfc;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.hscore.expression.number.Average;
import me.hsgamer.hscore.expression.string.Contains;
import me.hsgamer.hscore.expression.string.EndsWith;
import me.hsgamer.hscore.expression.string.Equals;
import me.hsgamer.hscore.expression.string.EqualsIgnoreCase;
import me.hsgamer.hscore.expression.string.Length;
import me.hsgamer.hscore.expression.string.MatchPattern;
import me.hsgamer.hscore.expression.string.StartsWith;

public final class ExpressionUtils {
    private static Function<ExpressionConfiguration, ExpressionConfiguration> expressionConfigurationModifier = configuration -> configuration.withAdditionalFunctions(new Map.Entry[]{Map.entry("AVG", new Average()), Map.entry("STRCT", new Contains()), Map.entry("STREDW", new EndsWith()), Map.entry("STREQ", new Equals()), Map.entry("STREQIC", new EqualsIgnoreCase()), Map.entry("STRLEN", new Length()), Map.entry("STRMP", new MatchPattern()), Map.entry("STRSTW", new StartsWith())});

    private ExpressionUtils() {
    }

    public static void registerFunction(String name, FunctionIfc function) {
        expressionConfigurationModifier = expressionConfigurationModifier.andThen(configuration -> configuration.withAdditionalFunctions(new Map.Entry[]{Map.entry(name, function)}));
    }

    public static void registerOperator(String name, OperatorIfc operator) {
        expressionConfigurationModifier = expressionConfigurationModifier.andThen(configuration -> configuration.withAdditionalOperators(new Map.Entry[]{Map.entry(name, operator)}));
    }

    public static Function<ExpressionConfiguration, ExpressionConfiguration> getExpressionConfigurationModifier() {
        return expressionConfigurationModifier;
    }

    public static ExpressionConfiguration getDefaultExpressionConfiguration() {
        return expressionConfigurationModifier.apply(ExpressionConfiguration.defaultConfiguration());
    }

    public static ExpressionConfiguration applyExpressionConfigurationModifier(ExpressionConfiguration configuration) {
        return expressionConfigurationModifier.apply(configuration);
    }
}

