/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.license.polymart;

import java.util.HashMap;
import java.util.Map;
import me.hsgamer.hscore.license.common.CommonLicenseProperty;
import me.hsgamer.hscore.license.common.LicenseProperties;

public class PolymartLicenseEntry {
    public final String user;
    public final String username;
    public final String resource;
    public final String resourceVersion;
    public final String nonce;
    public final String verifyToken;
    public final String license;
    public final String agent;
    public final String timestamp;

    public PolymartLicenseEntry(String user, String username, String resource, String resourceVersion, String nonce, String verifyToken, String license, String agent, String timestamp) {
        this.user = user;
        this.username = username;
        this.resource = resource;
        this.resourceVersion = resourceVersion;
        this.nonce = nonce;
        this.verifyToken = verifyToken;
        this.license = license;
        this.agent = agent;
        this.timestamp = timestamp;
    }

    public boolean isValid(boolean isPaid) {
        boolean valid;
        boolean bl = valid = this.user != null && !this.user.isEmpty() && !this.user.contains("__USER__") && this.username != null && !this.username.isEmpty() && !this.username.contains("__USERNAME__") && this.resource != null && !this.resource.isEmpty() && !this.resource.contains("__RESOURCE__") && this.resourceVersion != null && !this.resourceVersion.isEmpty() && !this.resourceVersion.contains("__RESOURCE_VERSION__") && this.timestamp != null && !this.timestamp.isEmpty() && !this.timestamp.contains("__TIMESTAMP__");
        if (valid && isPaid) {
            valid = this.nonce != null && !this.nonce.isEmpty() && !this.nonce.contains("__NONCE__") && this.verifyToken != null && !this.verifyToken.isEmpty() && !this.verifyToken.contains("__VERIFY_TOKEN__") && this.license != null && !this.license.isEmpty() && !this.license.contains("__LICENSE__") && this.agent != null && !this.agent.isEmpty() && !this.agent.contains("__AGENT__");
        }
        return valid;
    }

    public LicenseProperties toProperties() {
        LicenseProperties properties = new LicenseProperties();
        properties.put((Object)CommonLicenseProperty.TYPE, (Object)"polymart");
        properties.put((Object)CommonLicenseProperty.USER, (Object)this.user);
        properties.put((Object)"username", (Object)this.username);
        properties.put((Object)CommonLicenseProperty.RESOURCE, (Object)this.resource);
        properties.put((Object)"resourceVersion", (Object)this.resourceVersion);
        properties.put((Object)CommonLicenseProperty.NONCE, (Object)this.nonce);
        properties.put((Object)"verifyToken", (Object)this.verifyToken);
        properties.put((Object)"license", (Object)this.license);
        properties.put((Object)"agent", (Object)this.agent);
        properties.put((Object)"timestamp", (Object)this.timestamp);
        return properties;
    }

    public Map<String, String> toQueryMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("license", this.license);
        map.put("resource_id", this.resource);
        map.put("user_id", this.user);
        map.put("nonce", this.nonce);
        map.put("download_agent", this.agent);
        map.put("download_time", this.timestamp);
        map.put("download_token", this.verifyToken);
        return map;
    }
}

