/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.license.polymart;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Optional;
import java.util.function.Consumer;
import me.hsgamer.hscore.gson.GsonUtils;
import me.hsgamer.hscore.license.common.LicenseChecker;
import me.hsgamer.hscore.license.common.LicenseResult;
import me.hsgamer.hscore.license.common.LicenseStatus;
import me.hsgamer.hscore.license.polymart.PolymartLicenseEntry;
import me.hsgamer.hscore.license.polymart.PolymartLicenseFetcher;
import me.hsgamer.hscore.web.WebUtils;

public class PolymartLicenseChecker
implements LicenseChecker {
    private final String resource;
    private final boolean isPaid;
    private final boolean isDeepCheck;
    private final PolymartLicenseFetcher fetcher;
    private Consumer<Throwable> exceptionHandler = Throwable::printStackTrace;

    public PolymartLicenseChecker(String resource, boolean isPaid, boolean isDeepCheck, PolymartLicenseFetcher fetcher) {
        this.resource = resource;
        this.isPaid = isPaid;
        this.isDeepCheck = isDeepCheck;
        this.fetcher = fetcher;
    }

    public PolymartLicenseChecker(String resource, boolean isPaid, boolean isDeepCheck) {
        this(resource, isPaid, isDeepCheck, PolymartLicenseFetcher.defaultFetcher());
    }

    public static boolean isAvailable(String identifier) {
        return "1".equals(identifier);
    }

    public static boolean isAvailable() {
        String identifier = "%%__POLYMART__%%";
        return PolymartLicenseChecker.isAvailable(identifier);
    }

    public PolymartLicenseChecker setExceptionHandler(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<Boolean> isDeepValid(PolymartLicenseEntry entry) {
        String url = WebUtils.makeUrl((String)"https://api.polymart.org/v1/verifyPurchase/", entry.toQueryMap());
        try (InputStream inputStream = WebUtils.createConnection((String)url).getInputStream();){
            Optional<Boolean> optional;
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                JsonElement element = GsonUtils.parse((Reader)reader);
                if (!element.isJsonObject()) {
                    throw new IOException("Invalid JSON");
                }
                JsonElement response = element.getAsJsonObject().get("response");
                if (!response.isJsonObject()) {
                    throw new IOException("Invalid JSON");
                }
                JsonElement successElement = response.getAsJsonObject().get("success");
                if (!successElement.isJsonPrimitive()) {
                    throw new IOException("Invalid JSON");
                }
                optional = Optional.of(successElement.getAsBoolean());
            }
            return optional;
        }
        catch (Exception e) {
            this.exceptionHandler.accept(e);
            return Optional.empty();
        }
    }

    public LicenseResult checkLicense() {
        PolymartLicenseEntry entry = this.fetcher.fetchLicense();
        LicenseStatus status = !entry.isValid(this.isPaid) ? LicenseStatus.INVALID : (!this.resource.equals(entry.resource) ? LicenseStatus.UNKNOWN : (this.isPaid && this.isDeepCheck ? this.isDeepValid(entry).map(isDeepValid -> isDeepValid != false ? LicenseStatus.VALID : LicenseStatus.INVALID).orElse(LicenseStatus.OFFLINE) : LicenseStatus.VALID));
        return new LicenseResult(status, entry.toProperties());
    }
}

