/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.logger.system;

import me.hsgamer.hscore.logger.common.LogLevel;
import me.hsgamer.hscore.logger.common.Logger;

public class SystemLogger
implements Logger {
    private final String name;
    private boolean debug = false;

    public SystemLogger(String name) {
        this.name = name;
    }

    public SystemLogger(Class<?> clazz) {
        this(clazz.getSimpleName());
    }

    public SystemLogger printDebug() {
        this.debug = true;
        return this;
    }

    public void log(LogLevel level, String message) {
        if (level == LogLevel.DEBUG && !this.debug) {
            return;
        }
        if (level == LogLevel.ERROR) {
            System.err.println("[" + this.name + "/" + level.name() + "] " + message);
        } else {
            System.out.println("[" + this.name + "/" + level.name() + "] " + message);
        }
    }
}

