/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.impl.iterator;

import java.util.NoSuchElementException;
import me.hsgamer.hscore.minecraft.block.box.BlockBox;
import me.hsgamer.hscore.minecraft.block.box.Position;
import me.hsgamer.hscore.minecraft.block.iterator.BasePositionIterator;

public class LinearPositionIterator
extends BasePositionIterator {
    public static final LinearCoordinate X_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Position current, BasePositionIterator iterator) {
            return current.x < (double)iterator.box.maxX;
        }

        @Override
        public Position next(Position current) {
            return new Position(current.x + 1.0, current.y, current.z);
        }

        @Override
        public Position reset(Position current, BasePositionIterator iterator) {
            return new Position((double)iterator.box.minX, current.y, current.z);
        }
    };
    public static final LinearCoordinate Y_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Position current, BasePositionIterator iterator) {
            return current.y < (double)iterator.box.maxY;
        }

        @Override
        public Position next(Position current) {
            return new Position(current.x, current.y + 1.0, current.z);
        }

        @Override
        public Position reset(Position current, BasePositionIterator iterator) {
            return new Position(current.x, (double)iterator.box.minY, current.z);
        }
    };
    public static final LinearCoordinate Z_COORDINATE = new LinearCoordinate(){

        @Override
        public boolean hasNext(Position current, BasePositionIterator iterator) {
            return current.z < (double)iterator.box.maxZ;
        }

        @Override
        public Position next(Position current) {
            return new Position(current.x, current.y, current.z + 1.0);
        }

        @Override
        public Position reset(Position current, BasePositionIterator iterator) {
            return new Position(current.x, current.y, (double)iterator.box.minZ);
        }
    };
    private final LinearCoordinate[] coordinates;

    public LinearPositionIterator(BlockBox box, LinearCoordinate ... coordinates) {
        super(box);
        this.coordinates = coordinates;
    }

    public LinearPositionIterator(BlockBox box) {
        this(box, X_COORDINATE, Y_COORDINATE, Z_COORDINATE);
    }

    public Position initial() {
        return new Position((double)this.box.minX, (double)this.box.minY, (double)this.box.minZ);
    }

    public Position getContinue(Position current) throws NoSuchElementException {
        Position next = current;
        for (int i = 0; i < this.coordinates.length; ++i) {
            LinearCoordinate coordinate = this.coordinates[i];
            if (coordinate.hasNext(next, this)) {
                next = coordinate.next(next);
                break;
            }
            if (i == this.coordinates.length - 1) {
                throw new NoSuchElementException("No more elements");
            }
            next = coordinate.reset(next, this);
        }
        return next;
    }

    public boolean hasContinue(Position current) {
        return current.x < (double)this.box.maxX || current.y < (double)this.box.maxY || current.z < (double)this.box.maxZ;
    }

    public static interface LinearCoordinate {
        public boolean hasNext(Position var1, BasePositionIterator var2);

        public Position next(Position var1);

        public Position reset(Position var1, BasePositionIterator var2);
    }
}

