/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.impl.iterator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import me.hsgamer.hscore.minecraft.block.box.BlockBox;
import me.hsgamer.hscore.minecraft.block.box.Position;
import me.hsgamer.hscore.minecraft.block.iterator.BasePositionIterator;

public class RandomPositionIterator
extends BasePositionIterator {
    private final LinkedList<Position> queue = new LinkedList();

    public RandomPositionIterator(BlockBox box) {
        super(box);
    }

    public void reset() {
        super.reset();
        this.queue.clear();
    }

    public Position initial() {
        for (int x = this.box.minX; x <= this.box.maxX; ++x) {
            for (int y = this.box.minY; y <= this.box.maxY; ++y) {
                for (int z = this.box.minZ; z <= this.box.maxZ; ++z) {
                    this.queue.add(new Position((double)x, (double)y, (double)z));
                }
            }
        }
        Collections.shuffle(this.queue);
        return this.queue.poll();
    }

    public Position getContinue(Position current) throws NoSuchElementException {
        Position position = this.queue.poll();
        if (position == null) {
            throw new NoSuchElementException();
        }
        return position;
    }

    public boolean hasContinue(Position current) {
        return !this.queue.isEmpty();
    }
}

