/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.impl.iterator;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import me.hsgamer.hscore.common.CollectionUtils;
import me.hsgamer.hscore.minecraft.block.box.BlockBox;
import me.hsgamer.hscore.minecraft.block.box.Position;
import me.hsgamer.hscore.minecraft.block.iterator.AbstractPositionIterator;
import me.hsgamer.hscore.minecraft.block.iterator.PositionIterator;

public class RandomTypePositionIterator
extends AbstractPositionIterator {
    private final Collection<Function<BlockBox, PositionIterator>> functions;
    private final AtomicReference<PositionIterator> current;

    public RandomTypePositionIterator(BlockBox box, Collection<Function<BlockBox, PositionIterator>> functions) {
        super(box);
        this.functions = functions;
        this.current = new AtomicReference<PositionIterator>(this.getRandom());
    }

    private PositionIterator getRandom() {
        return (PositionIterator)Objects.requireNonNull((Function)CollectionUtils.pickRandom(this.functions)).apply(this.box);
    }

    public void reset() {
        this.current.set(this.getRandom());
    }

    public boolean hasNext() {
        return this.current.get().hasNext();
    }

    public Position next() {
        return (Position)this.current.get().next();
    }
}

