/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import me.hsgamer.hscore.collections.map.CaseInsensitiveStringHashMap;
import me.hsgamer.hscore.minecraft.block.box.BlockBox;
import me.hsgamer.hscore.minecraft.block.impl.iterator.LinearPositionIterator;
import me.hsgamer.hscore.minecraft.block.impl.iterator.RandomPositionIterator;
import me.hsgamer.hscore.minecraft.block.impl.iterator.RandomTypePositionIterator;
import me.hsgamer.hscore.minecraft.block.iterator.PositionIterator;

public final class PositionIteratorUtils {
    private static final Map<String, Function<BlockBox, PositionIterator>> TYPE_MAP = new CaseInsensitiveStringHashMap();

    private PositionIteratorUtils() {
    }

    public static void registerType(String type, Function<BlockBox, PositionIterator> typeFunction) {
        TYPE_MAP.put(type, typeFunction);
    }

    public static PositionIterator random(BlockBox box) {
        return new RandomTypePositionIterator(box, new ArrayList<Function<BlockBox, PositionIterator>>(TYPE_MAP.values()));
    }

    public static PositionIterator get(String type, BlockBox box) {
        return TYPE_MAP.getOrDefault(type, PositionIteratorUtils::random).apply(box);
    }

    public Collection<String> getRegisteredTypes() {
        return Collections.unmodifiableSet(TYPE_MAP.keySet());
    }

    static {
        PositionIteratorUtils.registerType("random", RandomPositionIterator::new);
        PositionIteratorUtils.registerType("xyz", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.X_COORDINATE, LinearPositionIterator.Y_COORDINATE, LinearPositionIterator.Z_COORDINATE}));
        PositionIteratorUtils.registerType("xzy", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.X_COORDINATE, LinearPositionIterator.Z_COORDINATE, LinearPositionIterator.Y_COORDINATE}));
        PositionIteratorUtils.registerType("yxz", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.Y_COORDINATE, LinearPositionIterator.X_COORDINATE, LinearPositionIterator.Z_COORDINATE}));
        PositionIteratorUtils.registerType("yzx", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.Y_COORDINATE, LinearPositionIterator.Z_COORDINATE, LinearPositionIterator.X_COORDINATE}));
        PositionIteratorUtils.registerType("zxy", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.Z_COORDINATE, LinearPositionIterator.X_COORDINATE, LinearPositionIterator.Y_COORDINATE}));
        PositionIteratorUtils.registerType("zyx", box -> new LinearPositionIterator(box, new LinearPositionIterator.LinearCoordinate[]{LinearPositionIterator.Z_COORDINATE, LinearPositionIterator.Y_COORDINATE, LinearPositionIterator.X_COORDINATE}));
        PositionIteratorUtils.registerType("default", LinearPositionIterator::new);
    }
}

