/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.box;

import java.util.Objects;
import me.hsgamer.hscore.minecraft.block.box.Position;

public class BlockBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public BlockBox(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public BlockBox(Position pos1, Position pos2) {
        this((int)pos1.x, (int)pos1.y, (int)pos1.z, (int)pos2.x, (int)pos2.y, (int)pos2.z);
    }

    public BlockBox expandMax(int x, int y, int z) {
        return new BlockBox(this.min(), this.max().move(x, y, z));
    }

    public BlockBox expandMin(int x, int y, int z) {
        return new BlockBox(this.min().move(-x, -y, -z), this.max());
    }

    public BlockBox expand(int x, int y, int z) {
        return this.expandMin(x, y, z).expandMax(x, y, z);
    }

    public BlockBox maxInclusive() {
        return this.expandMax(1, 1, 1);
    }

    public boolean contains(double x, double y, double z) {
        return x >= (double)this.minX && x <= (double)this.maxX && y >= (double)this.minY && y <= (double)this.maxY && z >= (double)this.minZ && z <= (double)this.maxZ;
    }

    public boolean contains(Position pos) {
        return this.contains(pos.x, pos.y, pos.z);
    }

    public Position center() {
        return new Position((double)(this.minX + this.maxX) / 2.0, (double)(this.minY + this.maxY) / 2.0, (double)(this.minZ + this.maxZ) / 2.0);
    }

    public Position min() {
        return new Position(this.minX, this.minY, this.minZ);
    }

    public Position max() {
        return new Position(this.maxX, this.maxY, this.maxZ);
    }

    public double sizeX() {
        return this.maxX - this.minX;
    }

    public double sizeY() {
        return this.maxY - this.minY;
    }

    public double sizeZ() {
        return this.maxZ - this.minZ;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockBox blockBox = (BlockBox)o;
        return this.minX == blockBox.minX && this.minY == blockBox.minY && this.minZ == blockBox.minZ && this.maxX == blockBox.maxX && this.maxY == blockBox.maxY && this.maxZ == blockBox.maxZ;
    }

    public int hashCode() {
        return Objects.hash(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

