/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.block.iterator;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import me.hsgamer.hscore.minecraft.block.box.BlockBox;
import me.hsgamer.hscore.minecraft.block.box.Position;
import me.hsgamer.hscore.minecraft.block.iterator.AbstractPositionIterator;

public abstract class BasePositionIterator
extends AbstractPositionIterator {
    private final AtomicReference<Position> current = new AtomicReference();

    protected BasePositionIterator(BlockBox box) {
        super(box);
    }

    public Position getCurrent() {
        return this.current.get();
    }

    public abstract Position initial();

    public abstract Position getContinue(Position var1) throws NoSuchElementException;

    public abstract boolean hasContinue(Position var1);

    @Override
    public void reset() {
        this.current.set(null);
    }

    @Override
    public boolean hasNext() {
        Position position = this.current.get();
        return position == null || this.hasContinue(position);
    }

    @Override
    public Position next() {
        Position position = this.getCurrent();
        position = position == null ? this.initial() : this.getContinue(position);
        this.current.set(position);
        return position;
    }
}

