/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.advanced;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.button.ButtonMap;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.NotNull;

public class AdvancedButtonMap
implements ButtonMap {
    private final List<Mask> masks = new LinkedList<Mask>();
    private boolean allowSlotDuplication = false;

    public void addMask(@NotNull Mask mask) {
        this.masks.add(mask);
    }

    public void removeMask(@NotNull String name) {
        this.masks.removeIf(mask -> mask.getName().equals(name));
    }

    @NotNull
    public @NotNull Collection<@NotNull Mask> removeAllMasks() {
        LinkedList<Mask> removedMasks = new LinkedList<Mask>(this.masks);
        this.masks.clear();
        return removedMasks;
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks(@NotNull String name) {
        return this.masks.parallelStream().filter(mask -> mask.getName().equals(name)).collect(Collectors.toList());
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks() {
        return Collections.unmodifiableList(this.masks);
    }

    public boolean isAllowSlotDuplication() {
        return this.allowSlotDuplication;
    }

    public void setAllowSlotDuplication(boolean allowSlotDuplication) {
        this.allowSlotDuplication = allowSlotDuplication;
    }

    @NotNull
    public Map<Button, Collection<Integer>> getButtons(@NotNull UUID uuid) {
        LinkedHashMap<Button, Collection<Integer>> buttonSlotMap = new LinkedHashMap<Button, Collection<Integer>>();
        if (this.allowSlotDuplication) {
            for (Mask mask : this.masks) {
                if (!mask.canView(uuid)) continue;
                Map buttons = mask.generateButtons(uuid);
                buttons.forEach((slot, button) -> buttonSlotMap.computeIfAbsent((Button)button, k -> new ArrayList()).add(slot));
            }
        } else {
            LinkedHashMap<Integer, Button> slotMap = new LinkedHashMap<Integer, Button>();
            for (Mask mask : this.masks) {
                if (!mask.canView(uuid)) continue;
                Map buttons = mask.generateButtons(uuid);
                slotMap.putAll(buttons);
            }
            slotMap.forEach((slot, button) -> buttonSlotMap.computeIfAbsent((Button)button, k -> new ArrayList()).add(slot));
        }
        return buttonSlotMap;
    }

    public void stop() {
        this.removeAllMasks().forEach(Initializable::stop);
    }
}

