/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.advanced;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hsgamer.hscore.minecraft.gui.button.ButtonMap;
import me.hsgamer.hscore.minecraft.gui.button.ViewedButton;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.NotNull;

public class AdvancedButtonMap
implements ButtonMap {
    private final List<Mask> masks = new LinkedList<Mask>();

    public void addMask(@NotNull Mask mask) {
        this.masks.add(mask);
    }

    public void removeMask(@NotNull String name) {
        this.masks.removeIf(mask -> mask.getName().equals(name));
    }

    @NotNull
    public @NotNull Collection<@NotNull Mask> removeAllMasks() {
        LinkedList<Mask> removedMasks = new LinkedList<Mask>(this.masks);
        this.masks.clear();
        return removedMasks;
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks(@NotNull String name) {
        return this.masks.parallelStream().filter(mask -> mask.getName().equals(name)).collect(Collectors.toList());
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks() {
        return Collections.unmodifiableList(this.masks);
    }

    public void stop() {
        this.removeAllMasks().forEach(Initializable::stop);
    }

    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull ViewedButton> getButtons(@NotNull UUID uuid, int size) {
        HashMap<Integer, ViewedButton> map = new HashMap<Integer, ViewedButton>();
        for (Mask mask : this.masks) {
            if (!mask.canView(uuid)) continue;
            Map buttons = mask.generateButtons(uuid, size);
            buttons.forEach((slot, button) -> {
                if (slot < 0 || slot >= size) {
                    return;
                }
                Item item = button.getItem(uuid);
                if (item == null && !button.forceSetAction(uuid)) {
                    return;
                }
                ViewedButton viewedButton = map.computeIfAbsent((Integer)slot, s -> new ViewedButton());
                if (item != null) {
                    viewedButton.setDisplayItem(item);
                }
                viewedButton.setButton(button);
            });
        }
        return map;
    }
}

