/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.button.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.event.ClickEvent;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ListButton
implements Button {
    private final List<Button> buttons = new ArrayList<Button>();
    private final Map<UUID, Integer> currentIndexMap = new ConcurrentHashMap<UUID, Integer>();
    private boolean keepCurrentIndex = false;

    @Contract(value="_ -> this")
    public <T extends Button> ListButton addButton(@NotNull @NotNull Collection<@NotNull T> buttons) {
        this.buttons.addAll(buttons);
        return this;
    }

    @Contract(value="_ -> this")
    public ListButton addButton(Button ... button) {
        return this.addButton(Arrays.asList(button));
    }

    public boolean isKeepCurrentIndex() {
        return this.keepCurrentIndex;
    }

    @Contract(value="_ -> this")
    public ListButton setKeepCurrentIndex(boolean keepCurrentIndex) {
        this.keepCurrentIndex = keepCurrentIndex;
        return this;
    }

    public void removeCurrentIndex(UUID uuid) {
        this.currentIndexMap.remove(uuid);
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    public Item getItem(@NotNull UUID uuid) {
        if (this.keepCurrentIndex && this.currentIndexMap.containsKey(uuid)) {
            return this.buttons.get(this.currentIndexMap.get(uuid)).getItem(uuid);
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            Item item = button.getItem(uuid);
            if (item == null && !button.forceSetAction(uuid)) continue;
            this.currentIndexMap.put(uuid, i);
            return item;
        }
        return null;
    }

    public void handleAction(ClickEvent event) {
        Optional.ofNullable(this.currentIndexMap.get(event.getViewerID())).map(this.buttons::get).ifPresent(button -> button.handleAction(event));
    }

    public boolean forceSetAction(@NotNull UUID uuid) {
        return Optional.ofNullable(this.currentIndexMap.get(uuid)).map(this.buttons::get).map(button -> button.forceSetAction(uuid)).orElse(false);
    }

    public void init() {
        this.buttons.forEach(Initializable::init);
    }

    public void stop() {
        this.buttons.forEach(Initializable::stop);
    }
}

