/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.button.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.GUIProperties;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.event.ClickEvent;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import me.hsgamer.hscore.ui.property.IdentifiedUpdatable;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AnimatedButton
implements Button,
IdentifiedUpdatable {
    private final List<Button> buttons = new ArrayList<Button>();
    private final Map<UUID, Integer> currentIndexMap = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastUpdateMap = new ConcurrentHashMap<UUID, Long>();
    private long periodMillis = 50L;

    @Contract(value="_ -> this")
    public AnimatedButton setPeriodMillis(long periodMillis) {
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.periodMillis = periodMillis;
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedButton setPeriodTicks(long periodTicks) {
        return this.setPeriodMillis(Math.max(periodTicks, 1L) * GUIProperties.getMillisPerTick());
    }

    @Contract(value="_ -> this")
    public <T extends Button> AnimatedButton addButton(@NotNull @NotNull Collection<@NotNull T> buttons) {
        this.buttons.addAll(buttons);
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedButton addButton(Button ... button) {
        return this.addButton(Arrays.asList(button));
    }

    public List<Button> getButtons() {
        return this.buttons;
    }

    private int getCurrentIndex(UUID uuid) {
        return this.currentIndexMap.getOrDefault(uuid, 0);
    }

    public Item getItem(@NotNull UUID uuid) {
        this.update(uuid);
        return this.buttons.get(this.getCurrentIndex(uuid)).getItem(uuid);
    }

    public void handleAction(ClickEvent event) {
        this.buttons.get(this.getCurrentIndex(event.getViewerID())).handleAction(event);
    }

    public boolean forceSetAction(@NotNull UUID uuid) {
        return this.buttons.get(this.getCurrentIndex(uuid)).forceSetAction(uuid);
    }

    public void init() {
        if (this.buttons.isEmpty()) {
            throw new IllegalArgumentException("There is no child button for this animated button");
        }
        this.buttons.forEach(Initializable::init);
    }

    public void stop() {
        this.buttons.forEach(Initializable::stop);
    }

    public void update(@NotNull UUID uuid) {
        long lastUpdate;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - (lastUpdate = this.lastUpdateMap.computeIfAbsent(uuid, k -> currentTimeMillis).longValue()) < this.periodMillis) {
            return;
        }
        long diff = currentTimeMillis - lastUpdate;
        long remainder = diff % this.periodMillis;
        int skip = (int)(diff / this.periodMillis);
        int currentIndex = this.getCurrentIndex(uuid);
        this.currentIndexMap.put(uuid, (currentIndex + skip) % this.buttons.size());
        this.lastUpdateMap.put(uuid, currentTimeMillis - remainder);
    }
}

