/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.button.impl;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.event.ClickEvent;
import me.hsgamer.hscore.minecraft.gui.object.Item;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PredicateButton
implements Button {
    private final Set<UUID> failToViewList = new ConcurrentSkipListSet<UUID>();
    private final Set<UUID> clickCheckList = new ConcurrentSkipListSet<UUID>();
    private Button button = EMPTY;
    private Button fallbackButton = EMPTY;
    private Predicate<UUID> viewPredicate = uuid -> true;
    private Function<ClickEvent, CompletableFuture<Boolean>> clickFuturePredicate = clickEvent -> CompletableFuture.completedFuture(true);
    private boolean preventSpamClick = false;

    @Contract(value="_ -> this")
    public PredicateButton setViewPredicate(@NotNull @NotNull Predicate<@NotNull UUID> viewPredicate) {
        this.viewPredicate = viewPredicate;
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setClickPredicate(@NotNull @NotNull Predicate<@NotNull ClickEvent> clickPredicate) {
        this.clickFuturePredicate = clickEvent -> CompletableFuture.supplyAsync(() -> clickPredicate.test((ClickEvent)clickEvent));
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setClickFuturePredicate(@NotNull @NotNull Function<@NotNull ClickEvent, @NotNull CompletableFuture<@NotNull Boolean>> clickFuturePredicate) {
        this.clickFuturePredicate = clickFuturePredicate;
        return this;
    }

    @Contract(value="_ -> this")
    public PredicateButton setPreventSpamClick(boolean preventSpamClick) {
        this.preventSpamClick = preventSpamClick;
        return this;
    }

    public Button getButton() {
        return this.button;
    }

    @Contract(value="_ -> this")
    public PredicateButton setButton(@NotNull Button button) {
        this.button = button;
        return this;
    }

    public Button getFallbackButton() {
        return this.fallbackButton;
    }

    @Contract(value="_ -> this")
    public PredicateButton setFallbackButton(@NotNull Button fallbackButton) {
        this.fallbackButton = fallbackButton;
        return this;
    }

    public Item getItem(@NotNull UUID uuid) {
        if (this.viewPredicate.test(uuid)) {
            this.failToViewList.remove(uuid);
            return this.button.getItem(uuid);
        }
        this.failToViewList.add(uuid);
        return this.fallbackButton.getItem(uuid);
    }

    public void handleAction(ClickEvent event) {
        UUID uuid = event.getViewerID();
        if (this.failToViewList.contains(uuid)) {
            this.fallbackButton.handleAction(event);
            return;
        }
        if (this.preventSpamClick && this.clickCheckList.contains(uuid)) {
            return;
        }
        this.clickCheckList.add(uuid);
        this.clickFuturePredicate.apply(event).thenAccept(result -> {
            this.clickCheckList.remove(uuid);
            if (Boolean.TRUE.equals(result)) {
                this.button.handleAction(event);
            }
        });
    }

    public boolean forceSetAction(@NotNull UUID uuid) {
        if (this.failToViewList.contains(uuid)) {
            return this.fallbackButton.forceSetAction(uuid);
        }
        return this.button.forceSetAction(uuid);
    }

    public void init() {
        this.button.init();
        this.fallbackButton.init();
    }

    public void stop() {
        this.button.stop();
        this.fallbackButton.stop();
    }
}

