/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class HybridMask
extends BaseMask {
    private final Map<Mask, Set<UUID>> maskMap = new LinkedHashMap<Mask, Set<UUID>>();

    public HybridMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> HybridMask addMask(@NotNull Collection<T> masks) {
        masks.forEach(mask -> this.maskMap.put((Mask)mask, new ConcurrentSkipListSet()));
        return this;
    }

    @Contract(value="_ -> this")
    public HybridMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    public Collection<Mask> getMasks() {
        return Collections.unmodifiableCollection(this.maskMap.keySet());
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid) {
        HashMap<Integer, Button> buttonMap = new HashMap<Integer, Button>();
        for (Map.Entry<Mask, Set<UUID>> entry : this.maskMap.entrySet()) {
            if (!entry.getValue().contains(uuid)) continue;
            buttonMap.putAll(entry.getKey().generateButtons(uuid));
        }
        return buttonMap;
    }

    @Override
    public boolean canView(@NotNull UUID uuid) {
        boolean canView = false;
        for (Map.Entry<Mask, Set<UUID>> entry : this.maskMap.entrySet()) {
            Set<UUID> uuidSet = entry.getValue();
            if (entry.getKey().canView(uuid)) {
                uuidSet.add(uuid);
                canView = true;
                continue;
            }
            uuidSet.remove(uuid);
        }
        return canView;
    }

    public void init() {
        this.maskMap.keySet().forEach(Initializable::init);
    }

    public void stop() {
        this.maskMap.keySet().forEach(Initializable::stop);
        this.maskMap.clear();
    }
}

