/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask;

import java.util.Collections;
import java.util.stream.IntStream;
import me.hsgamer.hscore.ui.Position2D;
import org.jetbrains.annotations.NotNull;

public class MaskUtils {
    private MaskUtils() {
    }

    public static int toSlot(int x, int y) {
        return x + y * 9;
    }

    @NotNull
    public static Position2D toPosition(int slot) {
        int x = slot % 9;
        int y = slot / 9;
        return Position2D.of((int)x, (int)y);
    }

    public static int toSlot(@NotNull Position2D position) {
        return MaskUtils.toSlot(position.getX(), position.getY());
    }

    public static IntStream generateAreaSlots(int x1, int y1, int x2, int y2) {
        Position2D max = Position2D.maxPosition((int)x1, (int)y1, (int)x2, (int)y2);
        Position2D min = Position2D.minPosition((int)x1, (int)y1, (int)x2, (int)y2);
        return IntStream.rangeClosed(min.getY(), max.getY()).flatMap(y -> IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), y), MaskUtils.toSlot(max.getX(), y)));
    }

    @NotNull
    public static IntStream generateAreaSlots(@NotNull Position2D position1, @NotNull Position2D position2) {
        return MaskUtils.generateAreaSlots(position1.getX(), position1.getY(), position2.getX(), position2.getY());
    }

    @NotNull
    public static IntStream generateOutlineSlots(int x1, int y1, int x2, int y2) {
        Position2D max = Position2D.maxPosition((int)x1, (int)y1, (int)x2, (int)y2);
        Position2D min = Position2D.minPosition((int)x1, (int)y1, (int)x2, (int)y2);
        IntStream top = IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), min.getY()), MaskUtils.toSlot(max.getX(), min.getY()));
        IntStream right = IntStream.rangeClosed(min.getY(), max.getY()).map(y -> MaskUtils.toSlot(max.getX(), y));
        IntStream bottom = IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), max.getY()), MaskUtils.toSlot(max.getX(), max.getY())).boxed().sorted(Collections.reverseOrder()).mapToInt(Integer::intValue);
        IntStream left = IntStream.rangeClosed(min.getY(), max.getY()).map(y -> MaskUtils.toSlot(min.getX(), y)).boxed().sorted(Collections.reverseOrder()).mapToInt(Integer::intValue);
        return IntStream.concat(top, IntStream.concat(right, IntStream.concat(bottom, left))).distinct();
    }

    @NotNull
    public static IntStream generateOutlineSlots(Position2D position1, Position2D position2) {
        return MaskUtils.generateOutlineSlots(position1.getX(), position1.getY(), position2.getX(), position2.getY());
    }
}

