/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PredicateMask
extends BaseMask {
    private final Set<UUID> failToViewList = new ConcurrentSkipListSet<UUID>();
    private Predicate<UUID> viewPredicate = uuid -> true;
    private Mask mask;
    private Mask fallbackMask;

    public PredicateMask(@NotNull String name) {
        super(name);
        this.mask = Mask.empty(name + "_empty");
        this.fallbackMask = Mask.empty(name + "_empty_fallback");
    }

    @Contract(value="_ -> this")
    public PredicateMask setViewPredicate(@NotNull @NotNull Predicate<@NotNull UUID> viewPredicate) {
        this.viewPredicate = viewPredicate;
        return this;
    }

    @NotNull
    public Mask getMask() {
        return this.mask;
    }

    @Contract(value="_ -> this")
    public PredicateMask setMask(@NotNull Mask mask) {
        this.mask = mask;
        return this;
    }

    @NotNull
    public Mask getFallbackMask() {
        return this.fallbackMask;
    }

    @Contract(value="_ -> this")
    public PredicateMask setFallbackMask(@NotNull Mask fallbackMask) {
        this.fallbackMask = fallbackMask;
        return this;
    }

    @Override
    public boolean canView(@NotNull UUID uuid) {
        if (this.viewPredicate.test(uuid)) {
            this.failToViewList.remove(uuid);
            return this.mask != null && this.mask.canView(uuid);
        }
        this.failToViewList.add(uuid);
        return this.fallbackMask != null && this.fallbackMask.canView(uuid);
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid) {
        if (this.failToViewList.contains(uuid)) {
            return this.fallbackMask != null ? this.fallbackMask.generateButtons(uuid) : Collections.emptyMap();
        }
        return this.mask != null ? this.mask.generateButtons(uuid) : Collections.emptyMap();
    }

    public void init() {
        if (this.mask != null) {
            this.mask.init();
        }
        if (this.fallbackMask != null) {
            this.fallbackMask.init();
        }
    }

    public void stop() {
        if (this.mask != null) {
            this.mask.stop();
        }
        if (this.fallbackMask != null) {
            this.fallbackMask.stop();
        }
    }
}

