/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderMask
extends BaseMask {
    protected final Map<UUID, Mask> userMasks = new ConcurrentHashMap<UUID, Mask>();
    protected Mask defaultMask;
    protected boolean initDefaultMask = true;

    public PlaceholderMask(@NotNull String name) {
        super(name);
        this.defaultMask = Mask.empty(name + "_empty");
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid) {
        return this.userMasks.getOrDefault(uuid, this.defaultMask).generateButtons(uuid);
    }

    public void init() {
        if (this.initDefaultMask) {
            this.defaultMask.init();
        }
    }

    public void stop() {
        if (this.initDefaultMask) {
            this.defaultMask.stop();
        }
        this.userMasks.clear();
    }

    public void setMask(@NotNull UUID uuid, @Nullable Mask mask) {
        if (mask == null) {
            this.userMasks.remove(uuid);
        } else {
            this.userMasks.put(uuid, mask);
        }
    }

    @Nullable
    public Mask getMask(@NotNull UUID uuid) {
        return this.userMasks.get(uuid);
    }

    @NotNull
    public Mask getDefaultMask() {
        return this.defaultMask;
    }

    @Contract(value="_ -> this")
    public PlaceholderMask setDefaultMask(@NotNull Mask defaultMask) {
        this.defaultMask = defaultMask;
        return this;
    }

    @Contract(value="_ -> this")
    public PlaceholderMask setInitDefaultMask(boolean initDefaultMask) {
        this.initDefaultMask = initDefaultMask;
        return this;
    }

    @NotNull
    public @NotNull Map<@NotNull UUID, @NotNull Mask> getUserMasks() {
        return Collections.unmodifiableMap(this.userMasks);
    }
}

