/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ButtonMapMask
extends BaseMask {
    private final List<Button> buttons = new ArrayList<Button>();
    private final Map<Integer, Button> buttonMap = new HashMap<Integer, Button>();

    public ButtonMapMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_, _ -> this")
    public ButtonMapMask addButton(@NotNull Button button, @NotNull @NotNull List<@NotNull Integer> slots) {
        this.buttons.add(button);
        slots.forEach(slot -> this.buttonMap.put((Integer)slot, button));
        return this;
    }

    @Contract(value="_, _ -> this")
    public ButtonMapMask addButton(@NotNull Button button, int ... slots) {
        this.buttons.add(button);
        for (int slot : slots) {
            this.buttonMap.put(slot, button);
        }
        return this;
    }

    @NotNull
    public List<Button> getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    @NotNull
    public Map<Integer, Button> getButtonMap() {
        return Collections.unmodifiableMap(this.buttonMap);
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid) {
        return this.buttonMap;
    }

    public void init() {
        this.buttons.forEach(Initializable::init);
    }

    public void stop() {
        this.buttons.forEach(Initializable::stop);
    }
}

