package me.hsgamer.hscore.minecraft.gui.mask.impl;

import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * The mask paginated mask, those with a long list of {@link Mask} divided into pages.
 */
public abstract class MaskPaginatedMask extends PaginatedMask {

  /**
   * Create a new mask
   *
   * @param name the name of the mask
   */
  protected MaskPaginatedMask(@NotNull String name) {
    super(name);
  }

  /**
   * Get the masks for the unique id
   *
   * @param uuid the unique id
   *
   * @return the masks
   */
  @NotNull
  public abstract List<@NotNull Mask> getMasks(@NotNull UUID uuid);

  @Override
  public @NotNull Map<Integer, Button> generateButtons(@NotNull UUID uuid) {
    List<Mask> masks = getMasks(uuid);
    return masks.isEmpty() ? Collections.emptyMap() : masks.get(this.getPage(uuid)).generateButtons(uuid);
  }

  @Override
  public boolean canView(@NotNull UUID uuid) {
    List<Mask> masks = getMasks(uuid);
    return !masks.isEmpty() && masks.get(this.getPage(uuid)).canView(uuid);
  }

  @Override
  public int getPageAmount(@NotNull UUID uuid) {
    return getMasks(uuid).size();
  }

  @Override
  public void stop() {
    this.pageNumberMap.clear();
  }
}
