/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import org.jetbrains.annotations.NotNull;

public abstract class PaginatedMask
extends BaseMask {
    protected final Map<UUID, Integer> pageNumberMap = new ConcurrentHashMap<UUID, Integer>();
    protected boolean cycle = false;

    protected PaginatedMask(@NotNull String name) {
        super(name);
    }

    public abstract int getPageAmount(@NotNull UUID var1);

    public void setPage(@NotNull UUID uuid, int page) {
        this.pageNumberMap.put(uuid, this.getExactPage(page, uuid));
    }

    public int getExactPage(int page, @NotNull UUID uuid) {
        int pageAmount = this.getPageAmount(uuid);
        if (pageAmount <= 0) {
            return 0;
        }
        if (this.cycle) {
            while (page < 0) {
                page += pageAmount;
            }
            page %= pageAmount;
        } else if (page < 0) {
            page = 0;
        } else if (page >= pageAmount) {
            page = pageAmount - 1;
        }
        return page;
    }

    public int getPage(@NotNull UUID uuid) {
        return this.pageNumberMap.computeIfAbsent(uuid, uuid1 -> 0);
    }

    public void nextPage(@NotNull UUID uuid) {
        this.setPage(uuid, this.getPage(uuid) + 1);
    }

    public void previousPage(@NotNull UUID uuid) {
        this.setPage(uuid, this.getPage(uuid) - 1);
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }
}

