/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask;

import java.util.Collections;
import java.util.stream.IntStream;
import me.hsgamer.hscore.minecraft.gui.object.InventoryPosition;
import org.jetbrains.annotations.NotNull;

public class MaskUtils {
    private MaskUtils() {
    }

    public static int toSlot(int x, int y, int slotPerRow) {
        return x + y * slotPerRow;
    }

    public static int toSlot(int x, int y) {
        return MaskUtils.toSlot(x, y, 9);
    }

    @NotNull
    public static InventoryPosition toPosition(int slot, int slotPerRow) {
        int x = slot % slotPerRow;
        int y = slot / slotPerRow;
        return InventoryPosition.of((int)x, (int)y);
    }

    @NotNull
    public static InventoryPosition toPosition(int slot) {
        return MaskUtils.toPosition(slot, 9);
    }

    public static int toSlot(@NotNull InventoryPosition position, int slotPerRow) {
        return MaskUtils.toSlot(position.getX(), position.getY(), slotPerRow);
    }

    public static int toSlot(@NotNull InventoryPosition position) {
        return MaskUtils.toSlot(position, 9);
    }

    public static IntStream generateAreaSlots(int x1, int y1, int x2, int y2, int slotPerRow) {
        InventoryPosition max = InventoryPosition.maxPosition((int)x1, (int)y1, (int)x2, (int)y2);
        InventoryPosition min = InventoryPosition.minPosition((int)x1, (int)y1, (int)x2, (int)y2);
        return IntStream.rangeClosed(min.getY(), max.getY()).flatMap(y -> IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), y, slotPerRow), MaskUtils.toSlot(max.getX(), y, slotPerRow)));
    }

    public static IntStream generateAreaSlots(int x1, int y1, int x2, int y2) {
        return MaskUtils.generateAreaSlots(x1, y1, x2, y2, 9);
    }

    @NotNull
    public static IntStream generateAreaSlots(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2, int slotPerRow) {
        return MaskUtils.generateAreaSlots(position1.getX(), position1.getY(), position2.getX(), position2.getY(), slotPerRow);
    }

    @NotNull
    public static IntStream generateAreaSlots(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2) {
        return MaskUtils.generateAreaSlots(position1, position2, 9);
    }

    @NotNull
    public static IntStream generateOutlineSlots(int x1, int y1, int x2, int y2, int slotPerRow) {
        InventoryPosition max = InventoryPosition.maxPosition((int)x1, (int)y1, (int)x2, (int)y2);
        InventoryPosition min = InventoryPosition.minPosition((int)x1, (int)y1, (int)x2, (int)y2);
        IntStream top = IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), min.getY(), slotPerRow), MaskUtils.toSlot(max.getX(), min.getY(), slotPerRow));
        IntStream right = IntStream.rangeClosed(min.getY(), max.getY()).map(y -> MaskUtils.toSlot(max.getX(), y, slotPerRow));
        IntStream bottom = IntStream.rangeClosed(MaskUtils.toSlot(min.getX(), max.getY(), slotPerRow), MaskUtils.toSlot(max.getX(), max.getY(), slotPerRow)).boxed().sorted(Collections.reverseOrder()).mapToInt(Integer::intValue);
        IntStream left = IntStream.rangeClosed(min.getY(), max.getY()).map(y -> MaskUtils.toSlot(min.getX(), y, slotPerRow)).boxed().sorted(Collections.reverseOrder()).mapToInt(Integer::intValue);
        return IntStream.concat(top, IntStream.concat(right, IntStream.concat(bottom, left))).distinct();
    }

    @NotNull
    public static IntStream generateOutlineSlots(int x1, int y1, int x2, int y2) {
        return MaskUtils.generateOutlineSlots(x1, y1, x2, y2, 9);
    }

    @NotNull
    public static IntStream generateOutlineSlots(InventoryPosition position1, InventoryPosition position2, int slotPerRow) {
        return MaskUtils.generateOutlineSlots(position1.getX(), position1.getY(), position2.getX(), position2.getY(), slotPerRow);
    }

    @NotNull
    public static IntStream generateOutlineSlots(InventoryPosition position1, InventoryPosition position2) {
        return MaskUtils.generateOutlineSlots(position1, position2, 9);
    }
}

