/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.GUIProperties;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.ui.property.IdentifiedUpdatable;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OneTimeAnimatedMask
extends BaseMask
implements IdentifiedUpdatable {
    private final List<Mask> masks = new ArrayList<Mask>();
    private final Map<UUID, SequenceRunner> runnerMap = new ConcurrentHashMap<UUID, SequenceRunner>();
    private boolean viewLast = false;
    private long periodMillis = 50L;

    public OneTimeAnimatedMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> OneTimeAnimatedMask addMask(@NotNull @NotNull Collection<@NotNull T> masks) {
        this.masks.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setPeriodMillis(long periodMillis) {
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.periodMillis = periodMillis;
        return this;
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setPeriodTicks(long periodTicks) {
        return this.setPeriodMillis(Math.max(periodTicks, 1L) * GUIProperties.getMillisPerTick());
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setViewLast(boolean viewLast) {
        this.viewLast = viewLast;
        return this;
    }

    @NotNull
    public List<Mask> getMasks() {
        return this.masks;
    }

    public void reset(@NotNull UUID uuid) {
        this.getRunner(uuid).reset();
    }

    private SequenceRunner getRunner(@NotNull UUID uuid) {
        return this.runnerMap.computeIfAbsent(uuid, k -> new SequenceRunner());
    }

    @Override
    public boolean canView(@NotNull UUID uuid) {
        this.update(uuid);
        return !this.getRunner(uuid).maxed || this.viewLast;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull Integer, @NotNull Button> generateButtons(@NotNull UUID uuid, int size) {
        return this.masks.get(this.getRunner(uuid).index).generateButtons(uuid, size);
    }

    public void update(@NotNull UUID uuid) {
        SequenceRunner runner = this.getRunner(uuid);
        if (!runner.maxed) {
            runner.updateIndex();
        }
    }

    public void init() {
        if (this.masks.isEmpty()) {
            throw new IllegalArgumentException("There is no child mask for this one-time animated mask");
        }
        this.masks.forEach(Initializable::init);
    }

    public void stop() {
        this.runnerMap.clear();
        this.masks.forEach(Initializable::stop);
        this.masks.clear();
    }

    private class SequenceRunner {
        private int index = 0;
        private long lastTickMillis = System.currentTimeMillis();
        private boolean maxed = false;

        private SequenceRunner() {
        }

        private void updateIndex() {
            long currentTick = System.currentTimeMillis();
            long diff = currentTick - this.lastTickMillis;
            if (diff < OneTimeAnimatedMask.this.periodMillis) {
                return;
            }
            int passed = (int)(diff / OneTimeAnimatedMask.this.periodMillis);
            long remainder = diff % OneTimeAnimatedMask.this.periodMillis;
            this.lastTickMillis = currentTick - remainder;
            int max = OneTimeAnimatedMask.this.masks.size();
            if (this.index + passed >= max) {
                this.index = max - 1;
                this.maxed = true;
            } else {
                this.index += passed;
            }
        }

        private void reset() {
            this.index = 0;
            this.lastTickMillis = System.currentTimeMillis();
            this.maxed = false;
        }
    }
}

