/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.GUIProperties;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.ui.property.IdentifiedUpdatable;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class AnimatedMask
extends BaseMask
implements IdentifiedUpdatable {
    private final List<Mask> masks = new ArrayList<Mask>();
    private final Map<UUID, Integer> currentIndexMap = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastUpdateMap = new ConcurrentHashMap<UUID, Long>();
    private long periodMillis = 50L;

    public AnimatedMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> AnimatedMask addMask(@NotNull @NotNull Collection<@NotNull T> masks) {
        this.masks.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    @Contract(value="_ -> this")
    public AnimatedMask setPeriodMillis(long periodMillis) {
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.periodMillis = periodMillis;
        return this;
    }

    @Contract(value="_ -> this")
    public AnimatedMask setPeriodTicks(long periodTicks) {
        return this.setPeriodMillis(Math.max(periodTicks, 1L) * GUIProperties.getMillisPerTick());
    }

    @NotNull
    public List<Mask> getMasks() {
        return this.masks;
    }

    private int getCurrentIndex(@NotNull UUID uuid) {
        return this.currentIndexMap.getOrDefault(uuid, 0);
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid, int size) {
        return this.masks.get(this.getCurrentIndex(uuid)).generateButtons(uuid, size);
    }

    @Override
    public boolean canView(@NotNull UUID uuid) {
        this.update(uuid);
        return this.masks.get(this.getCurrentIndex(uuid)).canView(uuid);
    }

    public void init() {
        if (this.masks.isEmpty()) {
            throw new IllegalArgumentException("There is no child mask for this animated mask");
        }
        this.masks.forEach(Initializable::init);
    }

    public void stop() {
        this.masks.forEach(Initializable::stop);
    }

    public void update(@NotNull UUID uuid) {
        long lastUpdate;
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - (lastUpdate = this.lastUpdateMap.computeIfAbsent(uuid, k -> currentTimeMillis).longValue()) < this.periodMillis) {
            return;
        }
        long diff = currentTimeMillis - lastUpdate;
        long remainder = diff % this.periodMillis;
        int skip = (int)(diff / this.periodMillis);
        int currentIndex = this.getCurrentIndex(uuid);
        this.currentIndexMap.put(uuid, (currentIndex + skip) % this.masks.size());
        this.lastUpdateMap.put(uuid, currentTimeMillis - remainder);
    }
}

