/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.impl.PaginatedMask;
import org.jetbrains.annotations.NotNull;

public abstract class SequencePaginatedMask
extends PaginatedMask {
    protected final List<Integer> slots = new ArrayList<Integer>();

    protected SequencePaginatedMask(@NotNull String name, @NotNull @NotNull List<@NotNull Integer> slots) {
        super(name);
        this.slots.addAll(slots);
    }

    @NotNull
    public @NotNull List<@NotNull Integer> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    @NotNull
    public abstract @NotNull List<@NotNull Button> getButtons(UUID var1);

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid, int size) {
        List<Button> buttons = this.getButtons(uuid);
        if (buttons.isEmpty() || this.slots.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Button> map = new HashMap<Integer, Button>();
        int basePage = this.getPage(uuid);
        int buttonsSize = buttons.size();
        int slotsSize = this.slots.size();
        for (int i = 0; i < slotsSize; ++i) {
            int index = i + basePage;
            if (this.cycle) {
                index = this.getExactPage(index, uuid);
            } else if (index >= buttonsSize) break;
            map.put(this.slots.get(i), buttons.get(index));
        }
        return map;
    }

    @Override
    public int getPageAmount(@NotNull UUID uuid) {
        return this.getButtons(uuid).size();
    }

    public void stop() {
        this.slots.clear();
        this.pageNumberMap.clear();
    }
}

