/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ListMask
extends BaseMask {
    private final List<Mask> masks = new ArrayList<Mask>();
    private final Map<UUID, Integer> currentIndexMap = new ConcurrentHashMap<UUID, Integer>();

    public ListMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> ListMask addMask(@NotNull @NotNull Collection<@NotNull T> masks) {
        this.masks.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public ListMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks() {
        return this.masks;
    }

    @Override
    public boolean canView(@NotNull UUID uuid) {
        for (int i = 0; i < this.masks.size(); ++i) {
            Mask mask = this.masks.get(i);
            if (!mask.canView(uuid)) continue;
            this.currentIndexMap.put(uuid, i);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid, int size) {
        return Optional.ofNullable(this.currentIndexMap.get(uuid)).map(this.masks::get).map(mask -> mask.generateButtons(uuid, size)).orElseGet(Collections::emptyMap);
    }

    public void init() {
        this.masks.forEach(Initializable::init);
    }

    public void stop() {
        this.masks.forEach(Initializable::stop);
    }
}

