/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MultiSlotsMask
extends BaseMask {
    protected final List<Integer> slots = new ArrayList<Integer>();
    protected final List<Button> buttons = new ArrayList<Button>();

    public MultiSlotsMask(@NotNull String name, @NotNull @NotNull List<@NotNull Integer> slots) {
        super(name);
        this.slots.addAll(slots);
    }

    @Contract(value="_ -> this")
    public <T extends Button> MultiSlotsMask addButton(@NotNull @NotNull Collection<@NotNull T> buttons) {
        this.buttons.addAll(buttons);
        return this;
    }

    @Contract(value="_ -> this")
    public MultiSlotsMask addButton(Button ... button) {
        return this.addButton(Arrays.asList(button));
    }

    @NotNull
    public @NotNull List<@NotNull Integer> getSlots() {
        return Collections.unmodifiableList(this.slots);
    }

    @NotNull
    public @NotNull List<@NotNull Button> getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    @Override
    @NotNull
    public Map<Integer, Button> generateButtons(@NotNull UUID uuid, int size) {
        HashMap<Integer, Button> map = new HashMap<Integer, Button>();
        if (!this.buttons.isEmpty()) {
            int slotsSize = this.slots.size();
            int buttonsSize = this.buttons.size();
            for (int i = 0; i < slotsSize; ++i) {
                map.put(this.slots.get(i), this.buttons.get(i % buttonsSize));
            }
        }
        return map;
    }

    public void init() {
        if (this.buttons.isEmpty()) {
            return;
        }
        this.buttons.forEach(Initializable::init);
    }

    public void stop() {
        if (this.buttons.isEmpty()) {
            return;
        }
        this.buttons.forEach(Initializable::stop);
    }
}

