/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class HybridMask
extends BaseMask {
    private final List<Mask> maskList = new ArrayList<Mask>();

    public HybridMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> HybridMask addMask(@NotNull Collection<T> masks) {
        this.maskList.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public HybridMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    public Collection<Mask> getMasks() {
        return Collections.unmodifiableList(this.maskList);
    }

    @Override
    public Optional<Map<Integer, Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize) {
        HashMap buttonMap = new HashMap();
        for (Mask mask : this.maskList) {
            mask.generateButtons(uuid, inventorySize).ifPresent(buttonMap::putAll);
        }
        return Optional.of(buttonMap);
    }

    public void init() {
        this.maskList.forEach(Initializable::init);
    }

    public void stop() {
        this.maskList.forEach(Initializable::stop);
    }
}

