/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.NotNull;

public abstract class PaginatedMask
extends BaseMask {
    protected final Map<UUID, Integer> pageNumberMap = new ConcurrentHashMap<UUID, Integer>();
    protected boolean cycle = false;

    protected PaginatedMask(@NotNull String name) {
        super(name);
    }

    protected abstract Optional<Map<@NotNull Integer, @NotNull Button>> generateButtons(@NotNull UUID var1, @NotNull InventorySize var2, int var3);

    protected int getExactPage(int page, int pageAmount) {
        int exactPage;
        if (pageAmount <= 0) {
            return 0;
        }
        if (this.cycle) {
            for (exactPage = page; exactPage < 0; exactPage += pageAmount) {
            }
            exactPage %= pageAmount;
        } else if (exactPage < 0) {
            exactPage = 0;
        } else if (exactPage >= pageAmount) {
            exactPage = pageAmount - 1;
        }
        return exactPage;
    }

    protected int getAndSetExactPage(UUID uuid, int page, int pageAmount) {
        int exactPage = this.getExactPage(page, pageAmount);
        if (exactPage != page) {
            this.setPage(uuid, exactPage);
        }
        return exactPage;
    }

    public void setPage(@NotNull UUID uuid, int page) {
        this.pageNumberMap.put(uuid, page);
    }

    public int getPage(@NotNull UUID uuid) {
        return this.pageNumberMap.computeIfAbsent(uuid, uuid1 -> 0);
    }

    public void nextPage(@NotNull UUID uuid) {
        this.setPage(uuid, this.getPage(uuid) + 1);
    }

    public void previousPage(@NotNull UUID uuid) {
        this.setPage(uuid, this.getPage(uuid) - 1);
    }

    public boolean isCycle() {
        return this.cycle;
    }

    public void setCycle(boolean cycle) {
        this.cycle = cycle;
    }

    @Override
    public Optional<Map<@NotNull Integer, @NotNull Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize) {
        return this.generateButtons(uuid, inventorySize, this.getPage(uuid));
    }
}

