/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.NotNull;

public interface MaskSlot {
    @NotNull
    public static MaskSlot of(@NotNull @NotNull List<@NotNull Integer> slots) {
        return (uuid, size) -> slots;
    }

    @NotNull
    public static MaskSlot of(Integer ... slots) {
        List<Integer> slotList = Arrays.asList(slots);
        return (uuid, size) -> slotList;
    }

    @NotNull
    public static MaskSlot of(@NotNull IntStream slotStream) {
        return MaskSlot.of(slotStream.boxed().collect(Collectors.toList()));
    }

    @NotNull
    public static MaskSlot of(@NotNull Function<InventorySize, List<Integer>> slotFunction) {
        return (uuid, size) -> (List)slotFunction.apply(size);
    }

    @NotNull
    public List<Integer> getSlots(UUID var1, InventorySize var2);
}

