/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask;

import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.hsgamer.hscore.minecraft.gui.object.InventoryPosition;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.NotNull;

public class MaskUtils {
    private MaskUtils() {
    }

    @NotNull
    public static Stream<InventoryPosition> generateAreaPositions(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2) {
        InventoryPosition max = InventoryPosition.maxPosition((InventoryPosition)position1, (InventoryPosition)position2);
        InventoryPosition min = InventoryPosition.minPosition((InventoryPosition)position1, (InventoryPosition)position2);
        return IntStream.rangeClosed(min.getY(), max.getY()).mapToObj(y -> IntStream.rangeClosed(min.getX(), max.getX()).mapToObj(x -> InventoryPosition.of((int)x, (int)y))).flatMap(Function.identity());
    }

    @NotNull
    public static IntStream generateAreaSlots(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2, @NotNull InventorySize size) {
        return size.toSlots(MaskUtils.generateAreaPositions(position1, position2));
    }

    @NotNull
    public static Stream<InventoryPosition> generateOutlineSlots(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2) {
        InventoryPosition max = InventoryPosition.maxPosition((InventoryPosition)position1, (InventoryPosition)position2);
        InventoryPosition min = InventoryPosition.minPosition((InventoryPosition)position1, (InventoryPosition)position2);
        Stream<InventoryPosition> top = IntStream.rangeClosed(min.getX(), max.getX()).mapToObj(x -> InventoryPosition.of((int)x, (int)min.getY()));
        Stream<InventoryPosition> right = IntStream.rangeClosed(min.getY(), max.getY()).mapToObj(y -> InventoryPosition.of((int)max.getX(), (int)y));
        Stream<InventoryPosition> bottom = IntStream.rangeClosed(min.getX(), max.getX()).mapToObj(x -> InventoryPosition.of((int)x, (int)max.getY()));
        Stream<InventoryPosition> left = IntStream.rangeClosed(min.getY(), max.getY()).mapToObj(y -> InventoryPosition.of((int)min.getX(), (int)y));
        return Stream.concat(Stream.concat(top, right), Stream.concat(bottom, left)).distinct();
    }

    @NotNull
    public static IntStream generateOutlineSlots(@NotNull InventoryPosition position1, @NotNull InventoryPosition position2, @NotNull InventorySize size) {
        return size.toSlots(MaskUtils.generateOutlineSlots(position1, position2));
    }
}

