/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class ListMask
extends BaseMask {
    private final List<Mask> masks = new ArrayList<Mask>();

    public ListMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> ListMask addMask(@NotNull @NotNull Collection<@NotNull T> masks) {
        this.masks.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public ListMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    @NotNull
    public @NotNull List<@NotNull Mask> getMasks() {
        return this.masks;
    }

    @Override
    public Optional<Map<Integer, Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize) {
        for (Mask mask : this.masks) {
            Optional<Map<Integer, Button>> buttons = mask.generateButtons(uuid, inventorySize);
            if (!buttons.isPresent()) continue;
            return buttons;
        }
        return Optional.empty();
    }

    public void init() {
        this.masks.forEach(Initializable::init);
    }

    public void stop() {
        this.masks.forEach(Initializable::stop);
    }
}

