/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.MaskSlot;
import me.hsgamer.hscore.minecraft.gui.mask.impl.PaginatedMask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.NotNull;

public abstract class SequencePaginatedMask
extends PaginatedMask {
    protected final MaskSlot maskSlot;

    protected SequencePaginatedMask(@NotNull String name, @NotNull MaskSlot maskSlot) {
        super(name);
        this.maskSlot = maskSlot;
    }

    @NotNull
    public MaskSlot getMaskSlot() {
        return this.maskSlot;
    }

    @NotNull
    public abstract @NotNull List<@NotNull Button> getButtons(UUID var1);

    @Override
    public Optional<Map<Integer, Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize, int pageNumber) {
        List<Integer> slots = this.maskSlot.getSlots(uuid, inventorySize);
        List<Button> buttons = this.getButtons(uuid);
        if (buttons.isEmpty() || slots.isEmpty()) {
            return Optional.empty();
        }
        int pageAmount = buttons.size();
        pageAmount = this.getAndSetExactPage(uuid, pageNumber, pageAmount);
        HashMap<Integer, Button> map = new HashMap<Integer, Button>();
        int basePage = this.getPage(uuid);
        int buttonsSize = buttons.size();
        int slotsSize = slots.size();
        for (int i = 0; i < slotsSize; ++i) {
            int index = i + basePage;
            if (this.cycle) {
                index = this.getExactPage(index, pageAmount);
            } else if (index >= buttonsSize) break;
            map.put(slots.get(i), buttons.get(index));
        }
        return Optional.of(map);
    }

    public void stop() {
        this.pageNumberMap.clear();
    }
}

