/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.MaskSlot;
import me.hsgamer.hscore.minecraft.gui.mask.impl.PaginatedMask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.NotNull;

public abstract class ButtonPaginatedMask
extends PaginatedMask {
    private final MaskSlot maskSlot;

    protected ButtonPaginatedMask(@NotNull String name, @NotNull MaskSlot maskSlot) {
        super(name);
        this.maskSlot = maskSlot;
    }

    @NotNull
    public MaskSlot getMaskSlot() {
        return this.maskSlot;
    }

    @NotNull
    public abstract @NotNull List<@NotNull Button> getButtons(@NotNull UUID var1);

    @Override
    protected Optional<Map<@NotNull Integer, @NotNull Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize, int pageNumber) {
        int index;
        List<Integer> slots = this.maskSlot.getSlots(uuid, inventorySize);
        List<Button> buttons = this.getButtons(uuid);
        if (buttons.isEmpty() || slots.isEmpty()) {
            return Optional.empty();
        }
        int pageAmount = (int)Math.ceil((double)buttons.size() / (double)slots.size());
        pageNumber = this.getAndSetExactPage(uuid, pageNumber, pageAmount);
        HashMap<Integer, Button> map = new HashMap<Integer, Button>();
        int slotsSize = slots.size();
        int offset = pageNumber * slotsSize;
        int buttonsSize = buttons.size();
        for (int i = 0; i < slotsSize && (index = i + offset) < buttonsSize; ++i) {
            map.put(slots.get(i), buttons.get(index));
        }
        return Optional.of(map);
    }

    public void stop() {
        this.pageNumberMap.clear();
    }
}

