/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.hsgamer.hscore.animate.Animation;
import me.hsgamer.hscore.minecraft.gui.GUIProperties;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import me.hsgamer.hscore.ui.property.Initializable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OneTimeAnimatedMask
extends BaseMask {
    private final List<Mask> masks = new ArrayList<Mask>();
    private final Map<UUID, Animation<Mask>> animationMap = new ConcurrentHashMap<UUID, Animation<Mask>>();
    private boolean viewLast = false;
    private long periodMillis = 50L;

    public OneTimeAnimatedMask(@NotNull String name) {
        super(name);
    }

    @Contract(value="_ -> this")
    public <T extends Mask> OneTimeAnimatedMask addMask(@NotNull @NotNull Collection<@NotNull T> masks) {
        this.masks.addAll(masks);
        return this;
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask addMask(Mask ... mask) {
        return this.addMask(Arrays.asList(mask));
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setPeriodMillis(long periodMillis) {
        if (periodMillis <= 0L) {
            throw new IllegalArgumentException("Period must be positive");
        }
        this.periodMillis = periodMillis;
        return this;
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setPeriodTicks(long periodTicks) {
        return this.setPeriodMillis(Math.max(periodTicks, 1L) * GUIProperties.getMillisPerTick());
    }

    @Contract(value="_ -> this")
    public OneTimeAnimatedMask setViewLast(boolean viewLast) {
        this.viewLast = viewLast;
        return this;
    }

    @NotNull
    public List<Mask> getMasks() {
        return this.masks;
    }

    public void reset(@NotNull UUID uuid) {
        this.getAnimation(uuid).reset();
    }

    private Animation<Mask> getAnimation(@NotNull UUID uuid) {
        return this.animationMap.computeIfAbsent(uuid, key -> new Animation(this.masks, this.periodMillis));
    }

    @Override
    public Optional<Map<@NotNull Integer, @NotNull Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize) {
        long currentMillis;
        Animation<Mask> animation = this.getAnimation(uuid);
        if (animation.isFirstRun(currentMillis = System.currentTimeMillis())) {
            return ((Mask)animation.getCurrentFrame(currentMillis)).generateButtons(uuid, inventorySize);
        }
        if (this.viewLast) {
            return this.masks.get(this.masks.size() - 1).generateButtons(uuid, inventorySize);
        }
        return Optional.empty();
    }

    public void init() {
        if (this.masks.isEmpty()) {
            throw new IllegalArgumentException("There is no child mask for this one-time animated mask");
        }
        this.masks.forEach(Initializable::init);
    }

    public void stop() {
        this.animationMap.clear();
        this.masks.forEach(Initializable::stop);
    }
}

