/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minecraft.gui.mask.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import me.hsgamer.hscore.minecraft.gui.button.Button;
import me.hsgamer.hscore.minecraft.gui.mask.BaseMask;
import me.hsgamer.hscore.minecraft.gui.mask.Mask;
import me.hsgamer.hscore.minecraft.gui.object.InventorySize;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PredicateMask
extends BaseMask {
    private Predicate<UUID> viewPredicate = uuid -> true;
    private Mask mask;
    private Mask fallbackMask;

    public PredicateMask(@NotNull String name) {
        super(name);
        this.mask = Mask.empty(name + "_empty");
        this.fallbackMask = Mask.empty(name + "_empty_fallback");
    }

    @Contract(value="_ -> this")
    public PredicateMask setViewPredicate(@NotNull @NotNull Predicate<@NotNull UUID> viewPredicate) {
        this.viewPredicate = viewPredicate;
        return this;
    }

    @NotNull
    public Mask getMask() {
        return this.mask;
    }

    @Contract(value="_ -> this")
    public PredicateMask setMask(@NotNull Mask mask) {
        this.mask = mask;
        return this;
    }

    @NotNull
    public Mask getFallbackMask() {
        return this.fallbackMask;
    }

    @Contract(value="_ -> this")
    public PredicateMask setFallbackMask(@NotNull Mask fallbackMask) {
        this.fallbackMask = fallbackMask;
        return this;
    }

    @Override
    public Optional<Map<Integer, Button>> generateButtons(@NotNull UUID uuid, @NotNull InventorySize inventorySize) {
        if (this.viewPredicate.test(uuid)) {
            return this.mask != null ? this.mask.generateButtons(uuid, inventorySize) : Optional.empty();
        }
        return this.fallbackMask != null ? this.fallbackMask.generateButtons(uuid, inventorySize) : Optional.empty();
    }

    public void init() {
        if (this.mask != null) {
            this.mask.init();
        }
        if (this.fallbackMask != null) {
            this.fallbackMask.init();
        }
    }

    public void stop() {
        if (this.mask != null) {
            this.mask.stop();
        }
        if (this.fallbackMask != null) {
            this.fallbackMask.stop();
        }
    }
}

