/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.board;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import me.hsgamer.hscore.common.CollectionUtils;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.player.PlayerDisconnectEvent;
import net.minestom.server.event.player.PlayerSpawnEvent;
import net.minestom.server.scoreboard.Sidebar;

public class Board {
    private static final Map<Player, Sidebar> boards = new ConcurrentHashMap<Player, Sidebar>();
    private static final int MAX_LINES = 15;
    private static final String MAGIC_STRING = "boardLine_";
    private final Function<Player, Component> title;
    private final Function<Player, List<Component>> lines;

    public Board(Function<Player, Component> title, Function<Player, List<Component>> lines) {
        this.title = title;
        this.lines = lines;
    }

    public static void hook(EventNode<Event> node, boolean initOnJoin, boolean removeOnQuit) {
        node.addListener(PlayerDisconnectEvent.class, event -> {
            if (removeOnQuit) {
                Board.remove(event.getPlayer());
            }
        }).addListener(PlayerSpawnEvent.class, event -> {
            if (event.isFirstSpawn() && initOnJoin) {
                Board.init(event.getPlayer());
            }
        });
    }

    public static void hook(EventNode<Event> node) {
        Board.hook(node, true, true);
    }

    public static void init(Player player) {
        if (boards.containsKey(player)) {
            return;
        }
        Sidebar sidebar = new Sidebar((Component)Component.text((String)""));
        sidebar.addViewer(player);
        boards.put(player, sidebar);
    }

    public static void remove(Player player) {
        Optional.ofNullable(boards.remove(player)).ifPresent(sidebar -> sidebar.removeViewer(player));
    }

    private static boolean update(Player player, Component title, List<Component> lines) {
        Sidebar sidebar = boards.get(player);
        if (sidebar == null) {
            return false;
        }
        sidebar.setTitle(title);
        List lineList = CollectionUtils.reverse(lines);
        for (int i = 0; i < 15; ++i) {
            Component component;
            String lineId = MAGIC_STRING + i;
            Sidebar.ScoreboardLine line = sidebar.getLine(lineId);
            Component component2 = component = i < lineList.size() ? (Component)lineList.get(i) : null;
            if (line == null && component == null) break;
            if (line == null) {
                sidebar.createLine(new Sidebar.ScoreboardLine(lineId, component, i));
                continue;
            }
            if (component == null) {
                sidebar.removeLine(lineId);
                continue;
            }
            sidebar.updateLineContent(lineId, component);
        }
        return true;
    }

    public boolean update(Player player) {
        return Board.update(player, this.title.apply(player), this.lines.apply(player));
    }
}

