/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui.inventory;

import java.util.Objects;
import java.util.UUID;
import me.hsgamer.hscore.minestom.gui.GUIDisplay;
import me.hsgamer.hscore.ui.property.Initializable;
import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.event.inventory.InventoryOpenEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.event.trait.InventoryEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.inventory.InventoryType;
import org.jetbrains.annotations.NotNull;

public class DelegatingInventory
extends Inventory
implements Initializable {
    private final EventNode<InventoryEvent> eventNode;
    private final GUIDisplay display;

    public DelegatingInventory(@NotNull InventoryType inventoryType, @NotNull Component title, @NotNull GUIDisplay display) {
        super(inventoryType, title);
        this.display = display;
        this.eventNode = EventNode.event((String)("inventory-" + UUID.randomUUID()), (EventFilter)EventFilter.INVENTORY, event -> Objects.equals(event.getInventory(), (Object)this));
    }

    public void init() {
        this.eventNode.addListener(InventoryOpenEvent.class, arg_0 -> ((GUIDisplay)this.display).handleEvent(arg_0));
        this.eventNode.addListener(InventoryPreClickEvent.class, arg_0 -> ((GUIDisplay)this.display).handleEvent(arg_0));
        this.eventNode.addListener(InventoryClickEvent.class, arg_0 -> ((GUIDisplay)this.display).handleEvent(arg_0));
        this.eventNode.addListener(InventoryCloseEvent.class, arg_0 -> ((GUIDisplay)this.display).handleEvent(arg_0));
        MinecraftServer.getGlobalEventHandler().addChild(this.eventNode);
    }

    public void stop() {
        this.clear();
        MinecraftServer.getGlobalEventHandler().removeChild(this.eventNode);
    }

    public EventNode<InventoryEvent> getEventNode() {
        return this.eventNode;
    }

    public GUIDisplay getDisplay() {
        return this.display;
    }
}

