/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import me.hsgamer.hscore.minestom.gui.GUIHolder;
import me.hsgamer.hscore.minestom.gui.button.Button;
import me.hsgamer.hscore.minestom.gui.inventory.DelegatingInventory;
import me.hsgamer.hscore.ui.BaseDisplay;
import me.hsgamer.hscore.ui.Holder;
import net.minestom.server.MinecraftServer;
import net.minestom.server.entity.Player;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.Inventory;
import net.minestom.server.item.ItemStack;

public class GUIDisplay
extends BaseDisplay<GUIHolder> {
    private final Map<Integer, Button> viewedButtons = new ConcurrentHashMap<Integer, Button>();
    private DelegatingInventory inventory;

    public GUIDisplay(UUID uuid, GUIHolder holder) {
        super(uuid, (Holder)holder);
    }

    public void handleClick(UUID uuid, InventoryPreClickEvent event) {
        Optional.ofNullable(this.viewedButtons.get(event.getSlot())).ifPresent(button -> {
            if (!button.handleAction(uuid, event)) {
                event.setCancelled(true);
            }
        });
    }

    public void handleClick(UUID uuid, InventoryClickEvent event) {
        Optional.ofNullable(this.viewedButtons.get(event.getSlot())).ifPresent(button -> button.handleAction(uuid, event));
    }

    public DelegatingInventory getInventory() {
        return this.inventory;
    }

    public void init() {
        this.inventory = new DelegatingInventory(((GUIHolder)this.holder).getInventoryType(), ((GUIHolder)this.holder).getTitleFunction().apply(this.uuid), this);
        this.inventory.init();
        this.update();
        Player player = MinecraftServer.getConnectionManager().getPlayer(this.uuid);
        if (player != null) {
            player.openInventory((Inventory)this.inventory);
        }
    }

    public void stop() {
        if (this.inventory != null) {
            this.inventory.stop();
        }
        this.viewedButtons.clear();
    }

    public void update() {
        if (this.inventory == null) {
            return;
        }
        int size = this.inventory.getSize();
        List emptyItemSlots = IntStream.range(0, size).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        List emptyActionSlots = IntStream.range(0, size).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Map<Button, List<Integer>> buttonSlots = ((GUIHolder)this.holder).getButtonMap().getButtons(this.uuid);
        buttonSlots.forEach((button, slots) -> {
            ItemStack itemStack = button.getItemStack(this.uuid);
            if (itemStack == null && !button.forceSetAction(this.uuid)) {
                return;
            }
            slots.forEach(slot -> {
                if (slot >= size) {
                    return;
                }
                if (itemStack != null) {
                    this.inventory.setItemStack((int)slot, itemStack);
                    emptyItemSlots.remove(slot);
                }
                this.viewedButtons.put((Integer)slot, (Button)button);
                emptyActionSlots.remove(slot);
            });
        });
        Button defaultButton = ((GUIHolder)this.holder).getButtonMap().getDefaultButton(this.uuid);
        ItemStack itemStack = Optional.ofNullable(defaultButton.getItemStack(this.uuid)).orElse(ItemStack.AIR);
        emptyItemSlots.forEach(slot -> this.inventory.setItemStack((int)slot, itemStack));
        emptyActionSlots.forEach(slot -> this.viewedButtons.put((Integer)slot, defaultButton));
    }
}

