/*
 * Decompiled with CFR 0.152.
 */
package me.hsgamer.hscore.minestom.gui;

import java.util.Collections;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import me.hsgamer.hscore.minestom.gui.GUIDisplay;
import me.hsgamer.hscore.minestom.gui.button.ButtonMap;
import me.hsgamer.hscore.ui.BaseHolder;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.event.inventory.InventoryCloseEvent;
import net.minestom.server.event.inventory.InventoryOpenEvent;
import net.minestom.server.event.inventory.InventoryPreClickEvent;
import net.minestom.server.inventory.InventoryType;

public class GUIHolder
extends BaseHolder<GUIDisplay> {
    private boolean removeDisplayOnClose = true;
    private InventoryType inventoryType = InventoryType.CHEST_3_ROW;
    private Function<UUID, Component> titleFunction = uuid -> Component.empty();
    private Predicate<UUID> closeFilter = uuid -> true;
    private ButtonMap buttonMap = uuid -> Collections.emptyMap();

    public boolean isRemoveDisplayOnClose() {
        return this.removeDisplayOnClose;
    }

    public void setRemoveDisplayOnClose(boolean removeDisplayOnClose) {
        this.removeDisplayOnClose = removeDisplayOnClose;
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType;
    }

    public Function<UUID, Component> getTitleFunction() {
        return this.titleFunction;
    }

    public void setTitleFunction(Function<UUID, Component> titleFunction) {
        this.titleFunction = titleFunction;
    }

    public Component getTitle(UUID uuid) {
        return this.titleFunction.apply(uuid);
    }

    public void setTitle(Component title) {
        this.setTitleFunction(uuid -> title);
    }

    public Predicate<UUID> getCloseFilter() {
        return this.closeFilter;
    }

    public void setCloseFilter(Predicate<UUID> closeFilter) {
        this.closeFilter = closeFilter;
    }

    public ButtonMap getButtonMap() {
        return this.buttonMap;
    }

    public void setButtonMap(ButtonMap buttonMap) {
        this.buttonMap = buttonMap;
    }

    protected GUIDisplay newDisplay(UUID uuid) {
        return new GUIDisplay(uuid, this);
    }

    public void init() {
        this.addEventConsumer(InventoryCloseEvent.class, event -> {
            Player player = event.getPlayer();
            UUID uuid = player.getUuid();
            if (!this.closeFilter.test(uuid)) {
                event.setNewInventory(event.getInventory());
            } else if (this.removeDisplayOnClose) {
                this.removeDisplay(uuid);
            }
        });
        this.addEventConsumer(InventoryOpenEvent.class, this::onOpen);
        this.addEventConsumer(InventoryCloseEvent.class, this::onClose);
        this.addEventConsumer(InventoryClickEvent.class, this::onClick);
        this.addEventConsumer(InventoryPreClickEvent.class, this::onClick);
        this.addEventConsumer(InventoryClickEvent.class, event -> {
            UUID uuid = event.getPlayer().getUuid();
            this.getDisplay(uuid).ifPresent(guiDisplay -> guiDisplay.handleClick(uuid, (InventoryClickEvent)event));
        });
        this.addEventConsumer(InventoryPreClickEvent.class, event -> {
            UUID uuid = event.getPlayer().getUuid();
            this.getDisplay(uuid).ifPresent(guiDisplay -> guiDisplay.handleClick(uuid, (InventoryPreClickEvent)event));
        });
        this.buttonMap.init();
    }

    protected void onOpen(InventoryOpenEvent event) {
    }

    protected void onClick(InventoryPreClickEvent event) {
    }

    protected void onClick(InventoryClickEvent event) {
    }

    protected void onClose(InventoryCloseEvent event) {
    }
}

